/**
******************************************************************************
* @file    scripts.h
* @author  Waveshare Team
* @version V1.0.0
* @date    23-January-2018
* @brief   This file describes the sending of JavaScript codes to a client
*
******************************************************************************
*/

void sendJS_A(WiFiClient client)
{
client.println(
"var srcBox,srcImg,dstImg;\r\n"
"var epdArr,epdInd,palArr;\r\n"
"var curPal;\r\n"
"function getElm(n){return document.getElementById(n);}\r\n"
"function setInn(n,i){ document.getElementById(n).innerHTML=i;}\r\n"

"function processFiles(files){\r\n"
    "var file=files[0];\r\n"
    "var reader=new FileReader();\r\n"
    "srcImg=new Image();\r\n"
    "reader.onload=function(e){\r\n"
        "setInn('srcBox','<img id=\"imgView\" class=\"sourceImage\">');\r\n"
        "var img=getElm('imgView');\r\n"
        "img.src=e.target.result;\r\n"
        "srcImg.src=e.target.result;\r\n"
    "};\r\n"
    
    "reader.readAsDataURL(file);\r\n"
"}\r\n"
//-------------------------------------------
"function drop(e){\r\n"
    "e.stopPropagation();\r\n"
    "e.preventDefault();\r\n"
    "var files=e.dataTransfer.files;\r\n"
    "processFiles(files);\r\n"
"}\r\n"
//-------------------------------------------
"function ignoreDrag(e){\r\n"
    "e.stopPropagation();\r\n"
    "e.preventDefault();\r\n"
"}\r\n"
//-------------------------------------------
"function getNud(nm,vl){\r\n"
    "return '<td class=\"comment\">'+nm+':</td>'+\r\n"
    "'<td><input id=\"nud_'+nm+'\" class=\"nud\"type=\"number\" value=\"'+vl+'\"/></td>';\r\n"
"}\r\n"
//-------------------------------------------
"function Btn(nm,tx,fn){\r\n"
    "return '<div><label class=\"menu_button\" for=\"_'+nm+'\">'+tx+'</label>'+\r\n"
    "'<input class=\"hidden_input\" id=\"_'+nm+'\" type=\"'+\r\n"
    "(nm==0?'file\" onchange=\"':'button\" onclick=\"')+fn+'\"/></div>';\r\n"
"}\r\n"
//-------------------------------------------
"function RB(vl,tx){\r\n"
    "return '<input type=\"radio\" name=\"kind\" value=\"m'+vl+\r\n"
  "'\" onclick=\"rbClick('+vl+');\"'+(vl==0?'checked=\"true\"':'')+'/>'+tx;\r\n"
"}\r\n"
//-------------------------------------------
"window.onload = function(){\r\n"
    "srcBox = getElm('srcBox');\r\n"
    "srcBox.ondragenter=ignoreDrag;\r\n"
    "srcBox.ondragover=ignoreDrag;\r\n"
    "srcBox.ondrop=drop;\r\n"
    "srcImg=0;\r\n"
    "epdInd=0;\r\n"

"palArr=[[[0,0,0],[255,255,255]],\r\n"
"[[0,0,0],[255,255,255],[127,0,0]],\r\n"
"[[0,0,0],[255,255,255],[127,127,127]],\r\n"
"[[0,0,0],[255,255,255],[127,127,127],[127,0,0]],\r\n"
"[[0,0,0],[255,255,255]],\r\n"
"[[0,0,0],[255,255,255],[220,180,0]],\r\n"
"[[0,0,0]],\r\n"
"[[0,0,0],[255,255,255],[0,255,0],[0,0,255],[255,0,0],[255,255,0],[255,128,0]]];\r\n"//5.65f 7-color E-Paper 
  
"epdArr=[[200,200,0],[200,200,3],[152,152,5],\r\n"
"[122,250,0],[104,212,1],[104,212,5],[104,212,0],\r\n"
"[176,264,0],[176,264,1],\r\n"
"[128,296,0],[128,296,1],[128,296,5],[128,296,0],\r\n"
"[400,300,0],[400,300,1],[400,300,5],\r\n"
"[600,448,0],[600,448,1],[600,448,5],\r\n"
"[640,384,0],[640,384,1],[640,384,5],\r\n"
"[800,480,0],[800,480,1],[880,528,1],\r\n"
"[600,448,7],[880,528,0],[280,480,0],\r\n"
"[152,296,0],[648,480,1],[128,296,1],\r\n"
"[200,200,1],[104,214,1],[128,296,0],\r\n"
"[400,300,1],[152,296,1],[648,480,0],\r\n"
"[640,400,7],[176,264,1],[122,250,0],\r\n"
"[122,250,1],[240,360,0],[176,264,0],\r\n"
"[122,250,0],[400,300,0],[960,680,0],\r\n"
"[800,480,0],[128,296,1],[960,680,1]];\r\n"

"setInn('BT',\r\n"
"Btn(0,'Select image file','processFiles(this.files);')+\r\n"
"Btn(1,'Level: mono','procImg(true,false);')+\r\n"
"Btn(2,'Level: color','procImg(true,true);')+\r\n"
"Btn(3,'Dithering: mono','procImg(false,false);')+\r\n"
"Btn(4,'Dithering: color','procImg(false,true);')+\r\n"
"Btn(5,'Upload image','uploadImage();'));\r\n"

"setInn('XY',getNud('x','0')+getNud('y','0'));\r\n"
"setInn('WH',getNud('w','200')+getNud('h','200'));\r\n"
  
"setInn('RB',RB(0,'1.54&ensp;')+RB(1,'1.54b')+RB(2,'1.54c&ensp;<br>')+\r\n"
"RB(3,'2.13&ensp;')+RB(4,'2.13b')+RB(5,'2.13c<br>')+\r\n"
"RB(6,'2.13d')+RB(7,'2.7&ensp;&ensp;')+RB(8,'2.7b&ensp;<br>')+\r\n"
"RB(9,'2.9&ensp;&ensp;')+RB(10,'2.9b&ensp;')+RB(11,'2.9c&ensp;<br>')+\r\n"
"RB(12,'2.9d&ensp;')+RB(13,'4.2&ensp;&ensp;')+RB(14,'4.2b&ensp;<br>')+\r\n"
"RB(15,'4.2c&ensp;')+RB(16,'5.83&ensp;')+RB(17,'5.83b<br>')+\r\n"
"RB(18,'5.83c&ensp;')+RB(19,'7.5&ensp;&ensp;')+RB(20,'7.5b&ensp;<br>')+\r\n"
"RB(21,'7.5c')+RB(22,'7.5 V2')+RB(23,'7.5b V2<br>')+\r\n"
"RB(24,'7.5b HD&ensp;')+RB(25,'5.65f<br>')+\r\n"
"RB(26,'7.5 HD&ensp;')+RB(27,'3.7&ensp;')+RB(28,'2.66<br>')+\r\n"
"RB(29,'5.83b V2&ensp;')+RB(30,'2.9b V3<br>')+\r\n"
"RB(31,'1.54b V2&ensp;')+RB(32,'2.13b V3<br>')+\r\n"
"RB(33,'2.9 V2&ensp;')+RB(34,'4.2b V2<br>')+\r\n"
"RB(35,'2.66b&ensp;')+RB(36,'5.83 V2<br>')+\r\n"
"RB(37,'4.01 f&ensp;')+RB(38,'2.7b V2<br>')+\r\n"
"RB(39,'2.13 V3&ensp;')+RB(40,'2.13 B V4<br>')+\r\n"
"RB(41,'3.52&ensp;')+RB(42,'2.7 V2<br>')+\r\n"
"RB(43,'2.13 V4&ensp;')+RB(44,'4.2 V2<br>')+\r\n"
"RB(45,'13.3k&ensp;')+RB(46,'4.26<br>')+\r\n"
"RB(47,'2.9bV4&ensp;')+RB(48,'13.3b<br>'));\r\n"
"}\r\n"
//-------------------------------------------
"function rbClick(index){\r\n"
    "getElm('nud_w').value=""+epdArr[index][0];\r\n"
    "getElm('nud_h').value=""+epdArr[index][1];\r\n"
    "epdInd=index;\r\n"
"}\r\n");
}

void sendJS_B(WiFiClient client)
{
client.println(
"var source;\r\n"
"var dX, dY, dW, dH, sW, sH;\r\n"
//-------------------------------------------
"function getVal(p, i){\r\n"
    "if((p.data[i]==0x00) && (p.data[i+1]==0x00))return 0;\r\n"
    "if((p.data[i]==0xFF) && (p.data[i+1]==0xFF))return 1;\r\n"
    "if((p.data[i]==0x7F) && (p.data[i+1]==0x7F))return 2;\r\n"
    "return 3;\r\n"
"}\r\n"
//-------------------------------------------
"function getVal_7color(p, i) {\r\n"//for 5.65f E-Paper
	"if((p.data[i]==0x00) && (p.data[i+1]==0x00) && (p.data[i+2]==0x00))return 0;\r\n"
	"if((p.data[i]==0xFF) && (p.data[i+1]==0xFF) && (p.data[i+2]==0xFF))return 1;\r\n"
	"if((p.data[i]==0x00) && (p.data[i+1]==0xFF) && (p.data[i+2]==0x00))return 2;\r\n"
	"if((p.data[i]==0x00) && (p.data[i+1]==0x00) && (p.data[i+2]==0xFF))return 3;\r\n"
	"if((p.data[i]==0xFF) && (p.data[i+1]==0x00) && (p.data[i+2]==0x00))return 4;\r\n"
	"if((p.data[i]==0xFF) && (p.data[i+1]==0xFF) && (p.data[i+2]==0x00))return 5;\r\n"
	"if((p.data[i]==0xFF) && (p.data[i+1]==0x80) && (p.data[i+2]==0x00))return 6;\r\n"
	"return 7;\r\n"
"}\r\n"
//-------------------------------------------
"function setVal(p,i,c){\r\n"
    "p.data[i]=curPal[c][0];\r\n"
    "p.data[i+1]=curPal[c][1];\r\n"
    "p.data[i+2]=curPal[c][2];\r\n"
    "p.data[i+3]=255;\r\n"
"}\r\n"
//-------------------------------------------
"function addVal(c,r,g,b,k){\r\n"
    "return[c[0]+(r*k)/32,c[1]+(g*k)/32,c[2]+(b*k)/32];\r\n"
"}\r\n"
//-------------------------------------------
"function getErr(r,g,b,stdCol){\r\n"
    "r-=stdCol[0];\r\n"
    "g-=stdCol[1];\r\n"
    "b-=stdCol[2];\r\n"
    "return r*r + g*g + b*b;\r\n"
"}\r\n"
//-------------------------------------------
"function getNear(r,g,b){\r\n"
    "var ind=0;\r\n"
    "var err=getErr(r,g,b,curPal[0]);\r\n"
    "for (var i=1;i<curPal.length;i++)\r\n"
    "{\r\n"
        "var cur=getErr(r,g,b,curPal[i]);\r\n"
        "if (cur<err){err=cur;ind=i;}\r\n"
    "}\r\n"
    "return ind;\r\n"
"}\r\n");
}

void sendJS_C(WiFiClient client)
{
    client.println(
"function procImg(isLvl,isRed){\r\n"
    "if (document.getElementsByClassName('sourceImage').length == 0){\r\n"
        "alert('First select image');\r\n"
        "return;\r\n"
    "}\r\n"
    
    "var palInd=epdArr[epdInd][2];\r\n"
    
    "if (isRed&&((palInd&1)==0)){\r\n"
        "alert('This white-black display');\r\n"
        "return;\r\n"
    "}\r\n"
    
    "if (!isRed)palInd=palInd&0xFE;\r\n"
    "curPal=palArr[palInd];\r\n"
    "getElm('dstBox').innerHTML=\r\n"
    "'<span class=\"title\">Processed image</span><br><canvas id=\"canvas\"></canvas>';\r\n" 
    "var canvas=getElm('canvas');\r\n"
    "sW=srcImg.width;\r\n"
    "sH=srcImg.height;\r\n"
    "source=getElm('source');\r\n"
    "source.width=sW;\r\n"
    "source.height=sH;\r\n"
    "source.getContext('2d').drawImage(srcImg,0,0,sW,sH);\r\n"
    "dX=parseInt(getElm('nud_x').value);\r\n"
    "dY=parseInt(getElm('nud_y').value);\r\n"
    "dW=parseInt(getElm('nud_w').value);\r\n"
    "dH=parseInt(getElm('nud_h').value);\r\n"
    
    "if((dW<3)||(dH<3)){\r\n"
        "alert('Image is too small');\r\n"
        "return;\r\n"
    "}\r\n"
    
    "canvas.width=dW;\r\n"
    "canvas.height=dH;\r\n"
    "var index=0;\r\n"
    "var pSrc=source.getContext('2d').getImageData(0,0,sW,sH);\r\n"
    "var pDst=canvas.getContext('2d').getImageData(0,0,dW,dH);\r\n"
    
    "if(isLvl){\r\n"
        "for (var j=0;j<dH;j++){\r\n"
            "var y=dY+j;\r\n"
            "if ((y<0)||(y>=sH)){\r\n"
                "for (var i=0;i<dW;i++,index+=4) setVal(pDst,index,(i+j)%2==0?1:0);\r\n"
                "continue;\r\n"
            "}\r\n"
            
            "for (var i=0;i<dW;i++){\r\n"
                "var x=dX+i;\r\n"
                
                "if ((x<0)||(x>=sW)){\r\n"
                    "setVal(pDst,index,(i+j)%2==0?1:0);\r\n"
                    "index+=4;\r\n"
                     "continue;\r\n"
                 "}\r\n"
                 
                 "var pos=(y*sW+x)*4;\r\n"     
                 "setVal(pDst,index,getNear(pSrc.data[pos],pSrc.data[pos+1],pSrc.data[pos+2]));\r\n"
                 "index+=4;\r\n"
             "}\r\n"
         "}\r\n"
    "}else{\r\n"
        "var aInd=0;\r\n"
        "var bInd=1;\r\n"
        "var errArr=new Array(2);\r\n"
        "errArr[0]=new Array(dW);\r\n"
        "errArr[1]=new Array(dW);\r\n"
        
        "for (var i=0;i<dW;i++)\r\n"
            "errArr[bInd][i]=[0,0,0];\r\n"
            
        "for (var j=0;j<dH;j++){\r\n"
            "var y=dY+j;\r\n"
            
            "if ((y<0)||(y>=sH)){\r\n"
                "for (var i=0;i<dW;i++,index+=4)setVal(pDst,index,(i+j)%2==0?1:0);\r\n"  
                "continue;\r\n"
            "}\r\n"
            
            "aInd=((bInd=aInd)+1)&1;\r\n"
            "for (var i=0;i<dW;i++)errArr[bInd][i]=[0,0,0];\r\n"
            
            "for (var i=0;i<dW;i++){\r\n"
                "var x=dX+i;\r\n"
                
                "if ((x<0)||(x>=sW)){\r\n"
                    "setVal(pDst,index,(i+j)%2==0?1:0);\r\n"
                    "index+=4;\r\n"
                    "continue;\r\n"
                "}\r\n"
                
                "var pos=(y*sW+x)*4;\r\n"
                "var old=errArr[aInd][i];\r\n"
                "var r=pSrc.data[pos  ]+old[0];\r\n"
                "var g=pSrc.data[pos+1]+old[1];\r\n"
                "var b=pSrc.data[pos+2]+old[2];\r\n"
                "var colVal = curPal[getNear(r,g,b)];\r\n"
                "pDst.data[index++]=colVal[0];\r\n"
                "pDst.data[index++]=colVal[1];\r\n"
                "pDst.data[index++]=colVal[2];\r\n"
                "pDst.data[index++]=255;\r\n"
                "r=(r-colVal[0]);\r\n"
                "g=(g-colVal[1]);\r\n"
                "b=(b-colVal[2]);\r\n"
                
                "if (i==0){\r\n"
                    "errArr[bInd][i  ]=addVal(errArr[bInd][i  ],r,g,b,7.0);\r\n"
                    "errArr[bInd][i+1]=addVal(errArr[bInd][i+1],r,g,b,2.0);\r\n"
                    "errArr[aInd][i+1]=addVal(errArr[aInd][i+1],r,g,b,7.0);\r\n"
                "}else if (i==dW-1){\r\n"
                    "errArr[bInd][i-1]=addVal(errArr[bInd][i-1],r,g,b,7.0);\r\n"
                    "errArr[bInd][i  ]=addVal(errArr[bInd][i  ],r,g,b,9.0);\r\n"
                "}else{\r\n"
                    "errArr[bInd][i-1]=addVal(errArr[bInd][i-1],r,g,b,3.0);\r\n"
                    "errArr[bInd][i  ]=addVal(errArr[bInd][i  ],r,g,b,5.0);\r\n"
                    "errArr[bInd][i+1]=addVal(errArr[bInd][i+1],r,g,b,1.0);\r\n"
                    "errArr[aInd][i+1]=addVal(errArr[aInd][i+1],r,g,b,7.0);\r\n"
                "}\r\n"
            "}\r\n"
        "}\r\n"
    "}\r\n"

    "canvas.getContext('2d').putImageData(pDst,0,0);\r\n"
"}\r\n");
}

void sendJS_D(WiFiClient client)
{
client.println(
"var pxInd,stInd;\r\n"
"var dispW,dispH;\r\n"
"var xhReq,dispX;\r\n"
"var rqPrf,rqMsg;\r\n"

"function byteToStr(v){return String.fromCharCode((v & 0xF) + 97, ((v >> 4) & 0xF) + 97);}\r\n"
"function wordToStr(v){return byteToStr(v&0xFF) + byteToStr((v>>8)&0xFF);}\r\n"

"function u_send(cmd,next)\r\n"
"{\r\n"
    "xhReq.open('POST',rqPrf+cmd, true);\r\n"
    "xhReq.send('');\r\n"

  "if(next)stInd++;\r\n"
  "return 0;\r\n" 
"}\r\n"

"function u_next()\r\n"
"{\r\n"
    "lnInd=0;\r\n"
    "pxInd=0;\r\n"
    "u_send('NEXT_',true);\r\n"
"}\r\n"

"function u_done()\r\n"
"{\r\n"
    "setInn('logTag','Complete!');\r\n"
    "return u_send('SHOW_',true);\r\n"
"}\r\n"

"function u_show(a,k1,k2)"
"{"
    "var x=''+(k1+k2*pxInd/a.length);"
    "if(x.length>5)x=x.substring(0,5);"
    "setInn('logTag','Progress: '+x+'%');"
    "return u_send(rqMsg+wordToStr(rqMsg.length)+'LOAD_',pxInd>=a.length);"
"}\r\n"

"function u_data(a,c,k1,k2)\r\n"
"{\r\n"
    "rqMsg='';\r\n"
  
    "if(c==-1)\r\n"
    "{\r\n"
        "while((pxInd<a.length)&&(rqMsg.length<1000))\r\n"
        "{\r\n"
            "var v=0;\r\n"
            "for (var i=0;i<16;i+=2)if(pxInd<a.length)v|=(a[pxInd++]<<i);\r\n"
            "rqMsg += wordToStr(v);\r\n"      
        "}\r\n"
    "}\r\n"
    "else if(c==-2)\r\n"
    "{\r\n"
        "while((pxInd<a.length)&&(rqMsg.length<1000))\r\n"
        "{\r\n"
            "var v=0;\r\n"
            "for (var i=0;i<16;i+=4)if(pxInd<a.length)v|=(a[pxInd++]<<i);\r\n"
            "rqMsg += wordToStr(v);\r\n"  
        "}\r\n"
    "}\r\n"
    "else\r\n"
    "{\r\n"
        "while((pxInd<a.length)&&(rqMsg.length<1000))\r\n"
        "{\r\n"
            "var v=0;\r\n"
            "for (var i=0;i<8;i++) if((pxInd<a.length)&&(a[pxInd++]!=c))v|=(128>>i);\r\n"           
            "rqMsg += byteToStr(v);\r\n"
        "}\r\n"
    "}\r\n"

  "return u_show(a,k1,k2);"
"}\r\n"

"function u_line(a,c,k1,k2)\r\n"
"{\r\n"
    "var x;\r\n"
    "rqMsg='';\r\n"
	"while(rqMsg.length<1000)\r\n"
	"{\r\n"
		"x=0;\r\n"
		"while(x<122)\r\n"
		"{\r\n"
			"var v=0;\r\n"
			"for (var i=0;(i<8)&&(x<122);i++,x++) if(a[pxInd++]!=c)v|=(128>>i);\r\n"
			"rqMsg += byteToStr(v);\r\n" 
		"}\r\n"
	"}\r\n"
    "return u_show(a,k1,k2);"
"}\r\n"

"function uploadImage()\r\n"
"{\r\n"
    "var c=getElm('canvas');\r\n"
    "var w=dispW=c.width;\r\n"
    "var h=dispH=c.height;\r\n"
    "var p=c.getContext('2d').getImageData(0,0,w,h);\r\n"
    "var a=new Array(w*h);\r\n"
    "var i=0;\r\n"
    "for(var y=0;y<h;y++)for(var x=0;x<w;x++,i++) {\r\n"
		"if(epdInd==25 || epdInd==37)\r\n"
			"a[i]=getVal_7color(p,i<<2);\r\n"
		"else\r\n"
			"a[i]=getVal(p,i<<2);\r\n"
	"}\r\n"
    "dispX=0;\r\n"
    "pxInd=0;\r\n"
    "stInd=0;\r\n"
    "xhReq=new XMLHttpRequest();\r\n"
    "rqPrf='http://'+getElm('ip_addr').value+'/';\r\n"
  
    "if ((epdInd==3)  || (epdInd==39) || (epdInd==43))\r\n" //2.13
    "{\r\n"
        "xhReq.onload=xhReq.onerror = function()\r\n" 
        "{\r\n"
            "if(stInd==0)return u_line(a,0,0,100);\r\n"
            "if(stInd==1)return u_done();\r\n"
        "};\r\n"
        
        "if(epdInd>25)\r\n"
			"return u_send('EPD'+String.fromCharCode(epdInd+-26+65)+'_',false);\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"  
    "}\r\n"

    "if ((epdInd==40))\r\n"	//2.13 B V4
    "{\r\n"
        "xhReq.onload=xhReq.onerror = function()\r\n" 
        "{\r\n"
            "if(stInd==0)return u_line(a,0,0,50);\r\n"
            "if(stInd==1)return u_next();\r\n"
			"if(stInd==2)return u_line(a,3,50,50);\r\n"
            "if(stInd==3)return u_done();\r\n"
        "};\r\n"
        "if(epdInd>25)\r\n"
			"return u_send('EPD'+String.fromCharCode(epdInd+-26+65)+'_',false);\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"  
    "}\r\n"

    "if ((epdInd==0)||(epdInd==3)||(epdInd==6)||(epdInd==7)||(epdInd==9)||(epdInd==12)||\
		(epdInd==16)||(epdInd==19)||(epdInd==22)||(epdInd==26)||(epdInd==27)||(epdInd==28))\r\n"
    "{\r\n"
        "xhReq.onload=xhReq.onerror=function()\r\n"
        "{\r\n"
            "if(stInd==0)return u_data(a,0,0,100);\r\n"
            "if(stInd==1)return u_done();\r\n"
        "};\r\n"
		"if(epdInd>25)\r\n"
			"return u_send('EPD'+String.fromCharCode(epdInd+-26+65)+'_',false);\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"
    "}\r\n"
  
	"if (epdInd>15 && epdInd < 22)\r\n"
    "{\r\n"
        "xhReq.onload=xhReq.onerror=function()\r\n"
        "{\r\n"
            "if(stInd==0)return u_data(a,-1,0,100);\r\n"
            "if(stInd==1)return u_done();\r\n"
        "};\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"   
    "}\r\n"
	
    "if (epdInd == 25 || epdInd == 37)\r\n"	// 7 colors
    "{\r\n"
        "xhReq.onload=xhReq.onerror=function()\r\n"
        "{\r\n"
            "if(stInd==0)return u_data(a,-2,0,100);\r\n"
            "if(stInd==1)return u_done();\r\n"
        "};\r\n"
		"if(epdInd>25)\r\n"
			"return u_send('EPD'+String.fromCharCode(epdInd+-26+65)+'_',false);\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"
    "}\r\n"
	
    "else\r\n"
    "{\r\n"
        "xhReq.onload=xhReq.onerror=function()\r\n"
        "{\r\n"
			"console.log('*************');\r\n"
			"console.log(stInd);\r\n"
			"console.log('*************');\r\n"
            "if(stInd==0&&epdInd==23)return u_data(a,0,0,100);\r\n"
            "if(stInd==0)return u_data(a,((epdInd==1)||(epdInd==12))?-1:0,0,50);\r\n"
            "if(stInd==1)return u_next();\r\n"
            "if(stInd==2)return u_data(a,3,50,50);\r\n" 
            "if(stInd==3)return u_done();\r\n"
        "};\r\n"
		"if(epdInd>25)\r\n"
			"return u_send('EPD'+String.fromCharCode(epdInd+-26+65)+'_',false);\r\n"
        "return u_send('EPD'+String.fromCharCode(epdInd+97)+'_',false);\r\n"
    "}\r\n"
"}\r\n\r\n");
}
